/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsAt;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsNbsp;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsNoBreakSpace;
import com.dickimawbooks.bibgls.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class Bib2GlsBibParser
extends BibParser {
    private GlsResource resource;
    private TeXParser bibParser;
    private File currentFile = null;

    public Bib2GlsBibParser(Bib2Gls bib2Gls, GlsResource glsResource, Charset charset) throws IOException {
        super((TeXApp)((Object)bib2Gls), charset, false);
        this.resource = glsResource;
        this.init();
    }

    private void init() {
        this.bibParser = new TeXParser(this);
        int n = this.bibParser.getCatCode(64);
        int n2 = this.bibParser.getCatCode(35);
        int n3 = 13;
        if (this.maketildeother) {
            n3 = this.bibParser.getCatCode(126);
        }
        this.bibParser.setCatCode(64, 13);
        this.bibParser.setCatCode(35, 12);
        if (this.maketildeother) {
            this.parser.setCatCode(126, 12);
        }
    }

    @Override
    public TeXParser getParser() {
        return this.bibParser;
    }

    @Override
    protected void addPredefined() {
        this.parser.putActiveChar(new Bib2GlsAt(this.resource));
        boolean bl = this.resource.useNonBreakSpace();
        this.parser.putActiveChar(new Bib2GlsNbsp(bl));
        this.parser.putControlSequence(new Bib2GlsNoBreakSpace(bl));
    }

    public void parse(File file) throws IOException {
        this.parser.parse(file, this.getCharSet());
    }

    @Override
    public void beginParse(File file, Charset charset) throws IOException {
        super.beginParse(file, charset);
        this.currentFile = file;
    }

    public File getBaseFile() {
        return this.currentFile;
    }

    public String getBase() {
        if (this.currentFile == null) {
            return null;
        }
        String string = this.currentFile.getName();
        int n = string.lastIndexOf(".bib");
        if (n == -1) {
            n = string.toLowerCase().lastIndexOf(".bib");
        }
        return n < 0 ? string.substring(0, n + 1) : string;
    }
}

